""" These functions are meant to provide better/consistent
error messages than straight up asserts.
"""

class UnsetError(Exception):
    pass

def requiresExists(obj, name):
    if not hasattr(obj, name):
        raise AttributeError("'%s' object has no attribute %s" % (obj, name))

def requiresNotNone(obj, name):
    requiresExists(obj, name)
    a = getattr(obj, name)
    if a is None:
        raise UnsetError("'%s.%s' has not been set yet." % (obj, name))

def requiresCallable(obj, name):
    requiresExists(obj, name)
    requiresNotNone(obj, name)
    a = getattr(obj, name)
    if not callable(a):
        raise TypeError("'%s' object is not callable (object '%s'.'%s'" % \
            (a, obj, name))
