"""
    A wrapper on argparse to make it easier to use outside the context
    of a terminal application.
"""
from argparse import ArgumentParser


class ArgParser(ArgumentParser):
    def __init__(self, name, args):
        ArgumentParser.__init__(self, prog=name, add_help=False)
        self.name = name
        for a in args:
            self.add_argument(a[0], **a[1])

    def help(self):
        return self.format_help()

    def parse(self, args):
        args, unks = self.parse_known_args(args[1:])
        if unks:
            raise ValueError("Invalid arguments: %s" % self.name)
        return args


def exceptReturnsHelp(parser):
    def decorator(func):
        def wrapped(args):
            try:
                args = parser.parse(args)
            except:
                return parser.help()
            return func(args)
        return wrapped
    return decorator

