from source.vcs import *


def test_avail():
    a = getAvailableVCS()
    assert("hg" in a)
    assert("git" in a)


def test_hg(tmpdir):
    init("hg", str(tmpdir))
    with open(tmpdir / "a", "w") as f:
        f.write("hello")
        f.close()
    report = getStatus("hg", str(tmpdir))
    assert(report[str(tmpdir / "a")] == "? ")
    add("hg", str(tmpdir), str(tmpdir / "a"))
    report = getStatus("hg", str(tmpdir))
    assert(report[str(tmpdir / "a")] == "A ")
    commitAll("hg", str(tmpdir), "Adding a file")
    report = listFiles("hg", str(tmpdir))
    assert(report[0] == str(tmpdir / "a"))
    with open(tmpdir / "a", "a") as f:
        f.write(" world!")
        f.close()
    assert(open(tmpdir / "a").read() == "hello world!")
    report = getModified("hg", str(tmpdir))
    assert(report[0] == str(tmpdir / "a"))
    report = getStatus("hg", str(tmpdir))
    assert(report[str(tmpdir / "a")] == "M ")

def test_git(tmpdir):
    init("git", str(tmpdir))
    with open(tmpdir / "a", "w") as f:
        f.write("hello")
        f.close()
    report = getStatus("git", str(tmpdir))
    assert(report[str(tmpdir / "a")] == "?? ")
    add("git", str(tmpdir), str(tmpdir / "a"))
    report = getStatus("git", str(tmpdir))
    assert(report[str(tmpdir / "a")] == "A  ")
    commitAll("git", str(tmpdir), "Adding a file")
    report = listFiles("git", str(tmpdir))
    assert(report[0] == str(tmpdir / "a"))
    with open(tmpdir / "a", "a") as f:
        f.write(" world!")
        f.close()
    assert(open(tmpdir / "a").read() == "hello world!")
    report = getModified("git", str(tmpdir))
    assert(report[0] == str(tmpdir / "a"))
    report = getStatus("git", str(tmpdir))
    assert(report[str(tmpdir / "a")] == " M ")
