from PySide2.QtCore import Qt
from source.pythonhelperdock import PythonHelper

from mocks import MockCtrl


def test_exercise1(qtbot):
    ctrl = MockCtrl()
    ctrl.gui = widget = PythonHelper("title", None, ctrl)
    widget.showMaximized()  # IMPORTANT!!!! QtWidgets might be testable without, but won't behave as expected
    qtbot.keyClicks(widget.cli, "os")
    qtbot.keyClick(widget.cli, Qt.Key_Return)
    result = widget.content.toPlainText()
    assert result.startswith("NAME\n    os")

    def clearCLI():
        widget.cli.clear()
    clearCLI()

    # Invalid request
    qtbot.keyClicks(widget.cli, "asdf")
    qtbot.keyClick(widget.cli, Qt.Key_Return)
    result = widget.content.toPlainText()
    assert result.startswith("NAME\n    os")

    # Test AUTOLIBS
    clearCLI()
    qtbot.keyClicks(widget.cli, "QTextEdit")
    qtbot.keyClick(widget.cli, Qt.Key_Return)
    result = widget.content.toPlainText()
    assert result.startswith("PySide2.QtWidgets.QTextEdit")
