from PySide2.QtCore import Qt
from source.gui import MainGui

from mocks import MockCtrl


def test_exercise1(qtbot, tmpdir):
    tmpfile = tmpdir.join("a.txt")
    tmpfile.ensure()
    tmpfile.write("Hello")

    ctrl = MockCtrl()
    ctrl.gui = widget = MainGui(ctrl)
    widget.showMaximized()  # IMPORTANT!!!! QtWidgets might be testable without, but won't behave as expected
    qtbot.addWidget(widget)
    qtbot.waitForWindowShown(widget)

    # TODO: abstract out key bindings from tests

    ### Test loading some text
    widget.open(str(tmpfile))
    #qtbot.waitUntil(lambda: widget.currentTool.hasFocus() or None)
    # I found that I had to refer directly to the widget that processes the keyEvent
    # I could not call keyClick on widget directly and expect event propagation
    # regardless of focus
    editor = widget.currentTool.main
    qtbot.keyClick(editor, Qt.Key_End)
    qtbot.keyClicks(editor, " World!")
    assert editor.toPlainText() == "Hello World!"
    widget.save()
    assert tmpfile.read() == "Hello World!"

    ### test tabify
    qtbot.keyPress(editor, Qt.Key_Home)
    qtbot.keyPress(editor, Qt.Key_Tab)
    editor.save()
    assert tmpfile.read() == "    Hello World!"

    ### test un-tabify
    # interesting that Shift+tab != Backtab. Hardware (or OS) translation?
    qtbot.keyPress(editor, Qt.Key_Backtab)
    editor.save()
    assert tmpfile.read() == "Hello World!"

    ### add more text
    qtbot.keyPress(editor, Qt.Key_End)
    qtbot.keyPress(editor, Qt.Key_Enter)  # no luck with \n in keyClicks
    qtbot.keyClicks(editor, "Goodbye universe.")
    qtbot.keyPress(editor, Qt.Key_Enter)  # no luck with \n in keyClicks
    qtbot.keyClicks(editor, "Que pasa?")
    editor.save()
    assert tmpfile.read() == "Hello World!\nGoodbye universe.\nQue pasa?"

    ### select and tabify
    # it seems to be important to use keyClick instead of keyPress to make modifiers work
    # or maybe moving the waitUntil hasFocus call to after opening the file was the key?
    qtbot.keyClick(editor, Qt.Key_Home, Qt.ControlModifier)
    qtbot.keyClick(editor, Qt.Key_Down, Qt.ShiftModifier)
    qtbot.keyClick(editor, Qt.Key_End, Qt.ShiftModifier)
    # I found some weird behavior here, so I tried stopping the test to inspect the gui
    # I found that the stoppage caused the test to pass which seems to indicate a delay
    # is required for selections to work properly
    # qtbot.stopForInteraction()
    # though this doesn't seem to be required I'm leaving it in as relatively harmless
    qtbot.waitSignal(editor.selectionChanged)
    # qtbot.wait(200)
    # negative: the difference appears to be how big the window is. See showMaximized above.
    qtbot.keyClick(editor, Qt.Key_Tab)

    editor.save()
    assert tmpfile.read() == "    Hello World!\n    Goodbye universe.\nQue pasa?"

    ### untabify selection
    qtbot.keyClick(editor, Qt.Key_Home, Qt.ControlModifier)
    qtbot.keyClick(editor, Qt.Key_Down, Qt.ShiftModifier)
    qtbot.keyClick(editor, Qt.Key_End, Qt.ShiftModifier)
    qtbot.waitSignal(editor.selectionChanged)
    qtbot.keyClick(editor, Qt.Key_Backtab)
    editor.save()
    assert tmpfile.read() == "Hello World!\nGoodbye universe.\nQue pasa?"
