from PySide2.QtWidgets import QVBoxLayout, QWidget, QLineEdit
from PySide2.QtWebEngineWidgets import QWebEngineView


class Web(QWidget):
    def __init__(self, ctrl):
        QWidget.__init__(self)
        self.ctrl = ctrl
        self.toolKey = "edit"
        self.lo = QVBoxLayout(self)
        self.addressBar = QLineEdit()
        self.addressBar.returnPressed.connect(self.get)
        self.addressBar.textChanged(self.triggerAuto)
        self.web = QWebEngineView()
        self.web.load("https://doc.qt.io/qtforpython")

        # DO LAYOUT
        self.lo.addWidget(self.addressBar)
        self.lo.addWidget(self.web)

    def get(self):
        # if not in the cache: request & cache
        # display from cache
        pass

    def getNew(self):
        # request latest copy of page, cache
        # self.get
        pass

    def triggerAuto(self):
        # use contents of cache to suggest autocomplete
        pass
