import os
import glob
import zipfile
import tarfile


def main(
    c=False,
    x=False,
    l=False,
    g=False,
    z=False,
    b=False,
    directory="",
    v=False,
    archive="",
    files=[],
):
    if c:
        if g or b:
            mode = "w"
        else:
            mode = "a"
        if os.path.exists(archive):
            if g or b:
                yield "ztar cannot append to files compressed with gzip or bzip2."
                return
            # TODO confirm
            pass
        if len(files) == 0:
            yield "ztar cannot create an archive from nothing."
            return
    elif x or l:
        mode = "r"
    else:
        yield "You must specify create (-c), extract (-x), or list (-l)."
        return
    func = None
    if z:
        if v:
            yield "Using zipfile module."
        func = zipfile.ZipFile
    elif g:
        mode += ":gz"
        if v:
            yield "Using gzip compression."
    elif b:
        mode += ":bz2"
        if v:
            yield "Using bzip2 compression."
    else:
        if v:
            yield "Using no compression."
    if not func:
        func = tarfile.open
        if v:
            yield "Using tarfile module."
    with func(archive, mode) as archive_fo:
        if l:
            try:
                for name in archive_fo.getnames():
                    yield name
            except:
                for name in archive_fo.namelist():
                    yield name
        elif len(files) == 0 and args.x:
            if directory:
                archive_fo.extractall(directory)
            else:
                archive_fo.extractall()
            if v:
                try:
                    for name in archive_fo.getnames():
                        yield name
                except:
                    for name in archive_fo.namelist():
                        yield name
        elif x:
            for arg in files:
                if directory:
                    archive_fo.extract(arg, directory)
                else:
                    archive_fo.extract(arg)
                if v:
                    yield arg
        elif c:
            for arg in files:
                for fn in glob.glob(arg):
                    try:
                        archive_fo.add(fn)
                    except:
                        archive_fo.write(fn)
                    if v:
                        yield fn
