import glob

try:
    import pwd
except:

    def getuserfromuid(uid):
        return str(uid)

else:

    def getuserfromuid(uid):
        return pwd.getpwuid(uid).pw_name


def humanize(size):
    # takes an integer size and turns it into a human readable string
    prefixes = ["T", "G", "M", "K"]
    divisors = [10**12, 10**9, 10**6, 10**3]
    for p, d in zip(prefixes, divisors):
        if size > d:
            return "%d%s" % (size / d, p)
    return str(size)


def expandall(args):
    result = []
    for a in args:
        result.extend(glob.glob(a))
    return result
