import os
import shutil
import argparse

parser = argparse.ArgumentParser(prog="rm", add_help=False)


def main(filenames, recurse=False):
    for path in filenames:
        if not recurse:
            if os.path.isdir(path):
                try:
                    os.rmdir(path)
                except Exception as e:
                    yield str(e)
            else:
                try:
                    os.remove(path)
                except Exception as e:
                    yield str(e)
        elif recurse:
            try:
                shutil.rmtree(path)
            except Exception as e:
                yield str(e)
