import os
import shutil


def main(source, destination, force=False):
    """As a cross platform implementation of mv, one meant to be used both by the
    command line and GUI. this utility must signal the parent if it needs to
    request input from the user
    """
    if len(source) > 1 and not os.path.isdir(args.destination):
        yield f"When moving multiple files the destination must be an existing directory.{destination} is not an existing directory."
        return
    for fn in source:
        if os.path.isdir(destination):
            shutil.move(fn, destination)
        elif os.path.isfile(destination):
            if force:
                shutil.move(fn, destination)
            else:
                yield f"{destination} already exists. Use -f to overwrite."
                return
        else:
            shutil.move(fn, destination)
