""" md5sum.py - a utility to make md5 hases of files
"""
import os
import sys
import glob
import hashlib
import functools


def md5sum(filename, blocksize=2048):
    h = hashlib.md5()
    with open(filename, "rb") as f:
        for block in iter(functools.partial(f.read, blocksize), b""):
            h.update(block)
    return h.hexdigest()


def main(filenames):
    for a in filenames:
        for fn in glob.iglob(a):
            if not os.path.exists(fn):
                yield f"{fn} file not found"
                continue
            yield f"{fn}: {md5sum(fn)}"
