import os
import re
import glob


def main(exp, filenames):
    try:
        rexp = re.compile(exp)
    except Exception as e:
        yield str(e)
        return
    for arg in filenames:
        for fn in glob.glob(arg):
            if os.path.isdir(fn):
                continue
            try:
                for line in open(fn, "r"):
                    if rexp.search(line):
                        yield f"{fn}: {line}"
            except Exception as e:
                yield f"Error reading {fn}: {e}"
                continue
