import os
import re


def main(start, filter=None):
    if filter:
        try:
            filter_re = re.compile(filter)
        except Exception as e:
            yield str(e)
            return
    result = []
    if not os.path.exists(start):
        yield f"Path: {start} does not exist."
    for root, dirs, files in os.walk(start):
        if not filter:
            for fn in files:
                yield os.path.join(root, fn)
        else:
            for fn in files:
                if filter_re.match(fn):
                    yield os.path.join(root, fn)
