import os
import glob
import shutil


def main(src, dst, force=False, recurse=False):
    srcfiles = []
    for s in src:
        srcfiles.extend(glob.glob(s))

    while len(srcfiles) > 0:
        s = srcfiles.pop()
        if os.path.isdir(s):
            if not recurse:
                yield f"cp: -r not specified; omitting directory '{s}'"
                continue
            srcfiles.extend(os.listdir(s))
        if os.path.exists(dst):
            if os.path.isdir(dst):
                fn = os.path.split(s)[1]
                d = os.path.join(dst, fn)
            else:
                d = dst
            if os.path.exists(d):
                if force:
                    os.remove(d)
                    shutil.copy(srcpath, d)
                else:
                    yield f"{d} exists. Use -f to overwrite."
                    return
        else:
            shutil.copy(s, dst)
