import os
import sys
import glob
import argparse

parser = argparse.ArgumentParser(description="a utility to concatenate files")
parser.add_argument("files", nargs="+", type=str)


def cat(filename):
    with open(filename) as f:
        for line in f:
            yield line


def main(filenames=[]):
    if type(filenames) is str:
        filenames = [filenames]
    for a in filenames:
        for fn in glob.iglob(a):
            if not os.path.exists(fn):
                yield f"{fn}: file not found"
                continue
            yield f"{fn}:"
            for line in cat(fn):
                yield line
