""" This module imports ALL the tools so it must never be a dependency elsewhere """


from source.editor import Editor
from source.openfilelistdock import OpenFileList
from source.projectstatusdock import ProjectStatus
from source.pythonhelperdock import PythonHelper
from source.terminal import Terminal
from source.search import SearchBox, ReplaceBox
from source.fman import FileManager
from source.simplepickerdock import SimplePickerDock
from source.actionlog import ActionLog

from source.dockwidget import ToolDock


_toolMap = {
    "editor" : Editor,
    "terminal" : Terminal,
    "fileList" : OpenFileList,
    "fileManager" : FileManager,
    "pythonHelper" : PythonHelper,
    "search" : SearchBox,
    "replace" : ReplaceBox,
    "actionLog" : ActionLog,
}


class ToolFactory:
    @classmethod
    def spawn(cls, key, ctrl):
        return _toolMap[key](ctrl)


