import sys
import jedi
import black
import pydoc
import subprocess
import traceback

# TODO: import sith

from pylint import epylint as lint
from source.basecls import Singleton
from source.resources import Settings


class Result:
    def __init__(self, error=False, message=""):
        self.error = error
        self.success = not error
        self.message = message

    def __str__(self):
        return self.message


class _Lightsaber:
    """I dunno, I just need a class ok.
    This class could morph into an interface to an LSP. For now it's just the interface to python specific tools.
    Hmmmm LSP = Light Saber... Protocol? Missed opporunity there MS...
    """

    def __init__(self):
        self.gui = None
        self.project_path = None
        # If you have a jedi project it gets stored here
        self.jedi_project = None
        self.jedi_interface = None

    def setup(self):
        pass

    def connect_gui(self, gui):
        self.gui = gui

    def change_project(self, path):
        self.project_path = path
        self.jedi_interface = jedi.Project(path)

    def compile(self, filename):
        """runs the given file through compile() and returns any errors"""
        source = open(filename).read()
        try:
            # should probably have non-default flags
            codeobj = compile(source, filename, "exec")
        except:
            t, val, tb = sys.exc_info()
            return Result(
                error=True, message="".join(traceback.format_exception(t, val, tb))
            )
        else:
            return Result(error=False, message="Compiled successfully.")

    def autoformat(self, filename):
        with open(filename) as f:
            contents = f.read()
        try:
            result = black.format_str(contents, mode=black.Mode())
        except Exception as e:
            return Result(error=True, message=f"{e}")
        else:
            if result != contents:
                with open(filename, "w") as f:
                    f.write(contents)
                return Result(error=False, message=f"{filename} reformatted.")
            else:
                return Result(error=False, message=f"{filename} saved.")

    def lint(self, filename):
        return
        output = ""
        for stream in lint.py_run(filename, return_std=True):
            output += stream.getvalue()
        if self.gui:
            self.gui.terminal.appendOutput(output)
            self.gui.toggleDock(self.gui.terminal)

    def help(self, prompt):
        result = Result(error=True)
        for prefix in Settings().get("autolibs"):
            # TODO Fix PySide2.QtWidgets lockup
            val = prefix + prompt
            obj = pydoc.locate(val)
            if obj is None:
                continue
            result = Result(error=False, message=pydoc.plaintext.document(obj, val))
            break
        return result

    def autocomplete(self, line, column, fileContents, filename):
        s = jedi.Script(fileContents, filename, project=self.jedi_project)
        prompt = fileContents.splitlines()[line - 1]
        return lambda: (prompt + c.complete for c in s.complete(line, column))

    def intelligent_help(self, prompt, fileContents, filename):
        if self.jedi_project:
            g = self.jedi_project.search(prompt)
        else:
            g = jedi.Script(fileContents, filename, project=self.jedi_project).search(
                prompt
            )
        return next(g).docstring()

Lightsaber = Singleton(_Lightsaber)
