from PySide2.QtWidgets import (
    QDockWidget,
    QLineEdit,
    QWidget,
    QLabel,
    QRadioButton,
    QCheckBox,
    QPushButton,
    QHBoxLayout,
)
from PySide2.QtGui import QTextDocument
from PySide2.QtCore import Qt


from source.toolregistry import ToolRegistry


class SearchField(QLineEdit):
    def __init__(self, dock):
        QLineEdit.__init__(self)
        self.dock = dock

    def focusOutEvent(self, event):
        QLineEdit.focusOutEvent(self, event)
        self.dock.focusOutEvent(event)


class ReplaceBox(QWidget):
    def __init__(self, ctrl):
        QWidget.__init__(self)
        self.setObjectName("ReplaceBox")
        self.label = lambda: "Find & Replace"
        self.toolKey = "replace"
        self.defaultLocation = "bottom"
        self.ctrl = ctrl

        self.findEdit = QLineEdit()
        self.replaceEdit = QLineEdit()
        self.replaceEdit.returnPressed.connect(self.replaceOne)
        self.findLabel = QLabel("Find:")
        self.replaceLabel = QLabel("Replace:")
        self.inLabel = QLabel("in")
        self.lineOpt = QRadioButton("&line", self)
        self.selectionOpt = QRadioButton("&selection", self)
        self.fileOpt = QRadioButton("&file", self)
        self.projectOpt = QRadioButton("&project", self)
        self.caseOpt = QCheckBox("Case &insensitive")
        # TODO: replace one button
        self.allBtn = QPushButton("Replace &All")
        self.allBtn.pressed.connect(self.replaceAll)

        self.lo = QHBoxLayout(self)
        self.lo.addWidget(self.findLabel)
        self.lo.addWidget(self.findEdit)
        self.lo.addWidget(self.replaceLabel)
        self.lo.addWidget(self.replaceEdit)
        self.lo.addWidget(self.inLabel)
        self.lo.addWidget(self.lineOpt)
        self.lo.addWidget(self.selectionOpt)
        self.lo.addWidget(self.fileOpt)
        self.lo.addWidget(self.projectOpt)
        self.lo.addWidget(self.caseOpt)
        self.lo.addWidget(self.allBtn)

    def setFocus(self):
        self.findEdit.setFocus()

    def hasFocus(self):
        return (
            self.findEdit.hasFocus()
            or self.replaceEdit.hasFocus()
            or self.lineOpt.hasFocus()
            or self.selectionOpt.hasFocus()
            or self.fileOpt.hasFocus()
            or self.projectOpt.hasFocus()
            or self.caseOpt.hasFocus()
            or self.allBtn.hasFocus()
        )

    def replaceAll(self):
        pass

    def replaceOne(self):
        # TODO: highlight/confirm
        needle = self.findEdit.text()
        if self.caseOpt.isChecked():
            ToolRegistry().onTop().search(needle, repeat=True)
        else:
            ToolRegistry().onTop().search(
                needle, repeat=True, flags=QTextDocument.FindCaseSensitively
            )
        ToolRegistry().onTop().replace(self.replaceEdit.text())


class SearchBox(QWidget):
    def __init__(self, ctrl):
        QWidget.__init__(self)
        self.setObjectName("SearchBox")
        self.label = lambda: "Find"
        self.toolKey = "search"
        self.defaultLocation = "bottom"
        self.ctrl = ctrl
        self.lo = QHBoxLayout(self)
        self.findEdit = SearchField(self)
        self.findEdit.returnPressed.connect(self.nextResult)
        self.findEdit.textChanged.connect(self.enterTerm)
        self.caseOpt = QCheckBox("Case &insensitive")
        self.lo.addWidget(self.findEdit)
        self.lo.addWidget(self.caseOpt)
        self.setFocusProxy(self.findEdit)

    def nextResult(self):
        self.enterTerm(repeat=False)

    def enterTerm(self, repeat=True):
        needle = self.findEdit.text()
        if self.caseOpt.isChecked():
            ToolRegistry().onTop().search(needle, repeat=repeat)
        else:
            ToolRegistry().onTop().search(
                needle, repeat=repeat, flags=QTextDocument.FindCaseSensitively
            )
