import io
import sys

from PySide2.QtWidgets import QDockWidget, QWidget, QTextEdit, QLineEdit, QVBoxLayout
from PySide2.QtCore import Qt

from source.terminal import CommandLineInterface
from source.theforce import Lightsaber


class PythonHelper(CommandLineInterface):
    def __init__(self, ctrl):
        CommandLineInterface.__init__(self, caret="help: ")
        self.setObjectName("PyHelperDock")
        self.label = lambda: "Python Help"
        self.toolKey = "helper"
        self.defaultLocation = "right"
        self.ctrl = ctrl

    def runCommand(self, cmd):
        result = Lightsaber().help(cmd)
        if result.success:
            self.append(str(result))
        else:
            self.append("")
        self.showPrompt()

    def prime(self, prompt):
        # prime the helper with a query
        self.runCommand(prompt)
