import os
import yaml
from typing import List
from dataclasses import dataclass, asdict


@dataclass
class Project:
    name: str
    path: str
    vcs: str
    savedStates: List[str]
    geometry: str
    docks: str


def createProject(name, path):
    if os.path.exists(os.path.join(path, ".hg")):
        vcs = "hg"
    elif os.path.exists(os.path.join(path, ".git")):
        vcs = "git"
    else:
        vcs = ""
    return Project(name=name, path=path, vcs=vcs, savedStates=[], docks="", geometry="")


def loadProject(path):
    fn = os.path.join(path, ".project.yaml")
    if not os.path.exists(fn):
        return
    project = Project(**yaml.safe_load(open(fn).read()))
    project.path = os.path.dirname(fn)
    return project


def saveProject(project):
    with open(os.path.join(project.path, ".project.yaml"), "w") as outfile:
        outfile.write(yaml.dump(asdict(project)))
