import os

from PySide2.QtWidgets import QDockWidget, QListWidget, QListWidgetItem
from PySide2.QtCore import Qt

from source.gui import MainGui


class OpenFileItem(QListWidgetItem):
    def __init__(self, text, filename, tool):
        QListWidgetItem.__init__(self, text)
        self.display = text
        self.filename = filename
        self.tool = tool


class OpenFileList(QListWidget):
    def __init__(self, ctrl):
        QListWidget.__init__(self)
        self.setObjectName("OpenFileListDock")
        self.label = lambda: f"Open Files ({self.count()})"
        self.toolKey = "fileList"
        self.defaultLocation = "left"
        self.ctrl = ctrl
        self.setSortingEnabled(True)
        self.itemActivated.connect(self.change)

    def _displayName(self, fn):
        if self.ctrl.project:
            return os.path.relpath(fn, self.ctrl.project.path)
        return fn

    def show(self):
        QListWidget.show(self)
        windowWidth = MainGui().size().width()
        # TODO: factor is configurable
        proposedWidth = int(0.2 * windowWidth)
        if proposedWidth < 200:
            proposedWidth = 200
        self.setMinimumWidth(proposedWidth)

    def addItem(self, tool):
        # TODO: scroll right if names are too long
        fn = str(tool.filename())
        item = OpenFileItem(self._displayName(fn), fn, tool)
        QListWidget.addItem(self, item)
        sb = self.horizontalScrollBar()
        sb.setValue(sb.maximum())

    def removeItem(self, tool):
        for row in range(self.count()):
            i = self.item(row)
            if i.tool == tool:
                self.takeItem(row)
                break

    def change(self, item):
        MainGui().switchTool(item.tool)

    def changeSelected(self, tool):
        for row in range(self.count()):
            i = self.item(row)
            if i.tool == tool:
                self.setCurrentItem(i)
                return

    def updateAll(self):
        # updates the display text for all items, called when the open project changes
        pass
