""" The base logging library *almost* gets me to here, but not quite. 
    I really like the simplicity of logging's top level functions (debug, error, etc),
    but they *only* ever write to the root logger and you can't change the name of
    the root logger AFAICT. And I *don't* want to save my logger to ctrl and I don't 
    want to store my logger name (for getLogger) in a every file.

    So here we are.

"""

import logging



Logger = logging.getLogger("shokunin")
h = logging.StreamHandler()
#fmt='shokunin-%(asctime)s-%(levelname)s- %(message)s', 
h.setFormatter(
    logging.Formatter(
        fmt='shokunin-%(levelname)s- %(message)s', 
        datefmt="%Y%m%d %H%M%S",
    )
)
Logger.addHandler(h)
Logger.setLevel(level=logging.INFO)
