""" A container for when a tool is moved onto a DockArea
"""

from PySide2.QtWidgets import QDockWidget
from PySide2.QtCore import Qt


class ToolDock(QDockWidget):
    def __init__(self, ctrl, parent, child):
        QDockWidget.__init__(self, child.label(), parent)
        self.ctrl = ctrl
        self.setWidget(child)
        self.setFocusProxy(child)
        self.child = child

    def show(self):
        QDockWidget.show(self)
        self.child.setFocus()

    def __getattr__(self, key):
        """pass failed attribute access on to the child widget"""
        return getattr(self.child, key)
