""" A Caching/Proxy Server
    Also a domain whitelisted search engine
    Design: on local side a single connection at a time is appropriate
        On network side, make requests concurrently

        Store content in files
        SQLite for fast searching.
        records: url, title, visits, cache date, filename, hash
        keywords: keyword (from URL & page title), record_fkey
        normalized titles: the title (and maybe URL) with normalized case and word separation
        keywords are 3 letters or longer (should remove "the", "and", etc?)

        search for all keywords entered, in the order given, in the normalized table
        SELECT r.url FROM records r, normalized n WHERE n.fkey=r.id AND n.keywords='[KEYWORDS]' ORDER BY r.visits DESC;
        also search for all keywords entered (space separated) in any order
        SELECT r.url FROM records r, keywords k1 INNER JOIN keywords k2 WHERE k1.fkey=r.id AND k1.fkey=k2.fkey AND k1.keyword='[KEYWORD1]' AND k2.keyword='[KEYWORD2]' ORDER BY r.visits DESC;
        expand JOIN for more keywords...
        results sorted by popularity (visits)

    Look into: https://github.com/mitmproxy/mitmproxy
"""
