""" A read-only log of actions as they are triggered """
from PySide2.QtWidgets import QTextEdit
from PySide2.QtCore import Qt


class ActionLog(QTextEdit):
    def __init__(self, ctrl):
        QTextEdit.__init__(self)
        self.setObjectName("ActionLog")
        self.label = lambda: "Action Log"
        self.toolKey = "actionLog"
        self.defaultLocation = "bottom"
        self.ctrl = ctrl
        self.setReadOnly(True)
        self.setFocusPolicy(Qt.NoFocus)

    def logAction(self, message):
        self.append(message)
