from PySide2.QtWidgets import QMenuBar, QMenu
from PySide2.QtGui import QKeySequence

STYLE = """QMenu::item {
    background-color: #111111;
    color: #EEEEEE;
    font-family: "DejaVu Sans Mono";
    font-size: 11pt;
}"""


class ActionBar(QMenuBar):
    def __init__(self, actions):
        QMenuBar.__init__(self)
        self.menus = {}
        for menuText, items in actions:
            menuObj = QMenu(menuText)
            for action in items:
                if action == "-":
                    menuObj.addSeparator()
                    continue
                qaction = menuObj.addAction(
                    action.menuText, action, QKeySequence(action.shortcut)
                )
                action.qaction = qaction
            self.addMenu(menuObj)
            key = menuText.lower().replace("&", "")
            # TODO: use key here instead
            self.menus[menuText] = menuObj

    def reloadStyle(self, style):
        for menuObj in self.menus.values():
            menuObj.setStyleSheet(style)
