### Libraries that python help will automatically search
autolibs = (
    "",
    "PySide2.QtWidgets.",
    "PySide2.QtGui.",
    "PySide2.QtCore.",
    "os.",
    "sys.",
)


### STYLES
def default():
    global QSS
    if sys.platform.startswith("win"):
        font = "Consolas"
    else:
        font = "DejaVu Sans Mono"
    font_size = "11pt"
    menu_font = font
    menu_font_size = font_size
    back_image = ""
    focus_border = "#990000"
    focus_back = "#000000"
    focus_fore = "#EEEEEE"
    low_contrast_back = "#111111"
    low_contrast_fore = "#666666"
    very_low_contrast_back = low_contrast_back
    very_low_contrast_fore = "#444444"
    dialogback1 = focus_back
    dialogback2 = low_contrast_back
    scrollbar_width = "8px"
    return Template(QSS).substitute(**locals())  # unused keywords are ignored


def thru_a_window():
    global QSS
    if sys.platform.startswith("win"):
        font = "Consolas"
    else:
        font = "DejaVu Sans Mono"
    font_size = "11pt"
    menu_font = font
    menu_font_size = font_size
    # TODO: fix path
    back_image = "./data/back.png"
    focus_border = "#990000"
    focus_back = "rgba(0, 0, 0, 75%)"
    focus_fore = "#EEEEEE"
    low_contrast_back = "rgba(0, 0, 0, 60%)"
    low_contrast_fore = "#AAAAAA"
    very_low_contrast_back = low_contrast_back
    very_low_contrast_fore = "#888888"
    # dialogs and menus don't support alpha
    dialogback1 = "#111"
    dialogback2 = "#1a1a1a"
    scrollbar_width = "8px"
    return Template(QSS).substitute(**locals())  # unused keywords are ignored


### SELECT CURRENT STYLE
style = thru_a_window

# keys are pygments Tokens
# style keys: foreground, italic, bold, background
HILITESTYLES = {
    "Comment": {"foreground": 0x00AA00, "italic": True},
    "Literal.String.Doc": {"foreground": 0x00AA00, "italic": True},
    "Keyword": {"foreground": 0xAA00FF},
    "Name": {"foreground": 0xFFFFFF},
    "Name.Function": {"foreground": 0xAA5500},
    "Name.Class": {"foreground": 0xAAAA00, "bold": True},
    "Literal.String": {"foreground": 0x5555FF},
    "Literal": {"foreground": 0xAA0000},
    "Operator": {"foreground": 0xAA0000},
    "Text": {"foreground": 0xFFFFFF},
}

"""    font-family: "$font";
    font-size: $font_size;
"""


QSS = """
QMainWindow#MainGui {
    background-image: url($back_image);
    background-position: bottom right; 
}
QWidget {
    color: $low_contrast_fore;
    font-family: "$font";
    border: 1px solid black;
    padding: 0;
    margin: 0;
}
Margin {
    background: $very_low_contrast_back;
    color: $very_low_contrast_fore;
    font-size: $font_size;
}
EditorArea {
    background: $focus_back;
    color: $focus_fore;
    font-size: $font_size;
}
Marks {
    background: $very_low_contrast_back;
    color: $very_low_contrast_fore;
    font-size: $font_size;
}
Overview {
    background: $very_low_contrast_back;
    color: $very_low_contrast_fore;
}
#Central QTextEdit {
    background: $focus_back;
    color: $focus_fore;
}
#Central QLineEdit {
    background: $focus_back;
    color: $focus_fore;
}
#Central QListWidget {
    background: $focus_back;
    color: $focus_fore;
}
QDockWidget {
    border: 1px solid black;
}
QDockWidget::title {
    background: $low_contrast_back;
}
QDockWidget QListWidget {
    background: $low_contrast_back;
    color: $low_contrast_fore;
}
QDockWidget QTextEdit {
    background: $low_contrast_back;
    color: $low_contrast_fore;
}
QDockWidget QLineEdit {
    background: $low_contrast_back;
    color: $low_contrast_fore;
}
QWidget:focus {
    border: 1px solid $focus_border;
}
QStatusBar {
    background: $low_contrast_back;
    color: $low_contrast_fore;
}
QMenuBar {
    background: $low_contrast_back;
    color: $low_contrast_fore;
    font-weight: bold;
    font-size: $font_size;
}
QListWidget {
    font-size: $font_size;
}
QScrollBar::vertical {
    width: $scrollbar_width;
}
QScrollBar::horizontal {
    width: $scrollbar_width;
}
QMenu::item {
    background-color: $dialogback1;
    color: $low_contrast_fore;
    font-family: $menu_font;
    font-size: $menu_font_size;
}
QMenu::item:selected {
    background-color: $low_contrast_fore;
    color: $dialogback2;
    font-family: $menu_font;
    font-size: $menu_font_size;
}
QMenu::separator {
    background: $low_contrast_fore;
}
QDialog {
    background: $dialogback1;
    font-size: $font_size;
}
QDialog QWidget {
    background: $dialogback2;
    font-size: $font_size;
}
"""
