/*** INCLUDES ***/
#include <ctype.h>
//iscntrl
#include <errno.h>
#include <stdio.h>
//printf, perror
#include <stdlib.h>
//atexit, exit
#include <termios.h>
//tcsetattr
//tcgetattr
//struct termios
//ECHO, ICANON, ISIG, IXON, IEXTEN, etc
//TCSAFLUSH
// VMIN, VTIME
#include <unistd.h>
//STDIN_FILENO

/*** DEFINES ***/
#define CTRL_KEY(k) ((k) & 0x1f)
#define TRAP(e, s) if (e == -1) die(s)


/*** DATA ***/

struct termios orig_termios;

/*** TERMINAL ***/

void die(const char *s) {
    // will print the errno
    perror(s);
    exit(1);
}

void disableRawMode() {
    TRAP(tcsetattr(STDIN_FILENO, TCSAFLUSH, &orig_termios), 
            "disableRawMode: tcsetattr");
}

void enableRawMode() {
    TRAP(tcgetattr(STDIN_FILENO, &orig_termios),
        "enableRawMode: tcgetattr");
    atexit(disableRawMode);

    struct termios raw = orig_termios;
    // _i_nput flag
    raw.c_iflag &= ~(BRKINT | ICRNL | INPCK | ISTRIP | IXON);
    // _o_utput flag
    raw.c_oflag &= ~(OPOST);
    // _c_ontrol flag
    raw.c_cflag |= (CS8);
    // _l_ocal flag
    raw.c_lflag &= ~(ECHO | ICANON | ISIG | IEXTEN);
    raw.c_cc[VMIN] = 0;
    raw.c_cc[VTIME] = 1; // = 0.1 sec

    TRAP(tcsetattr(STDIN_FILENO, TCSAFLUSH, &raw),
        "enableRawMode: tcsetattr");
}

/*** INIT ***/

int main() {
    enableRawMode();

    while (1) {
        char c = '\0';
        if (read(STDIN_FILENO, &c, 1) == -1 && errno != EAGAIN)
            die("main: read");
        if (iscntrl(c)) {
            printf("%d\r\n", c);
        } else {
            printf("%d ('%c')\r\n", c, c);
        } // end if

        //if (c == 'q') break;
        if (c == CTRL_KEY('q')) break;

    } // end while

    return 0;
}
